<?php

namespace App\Console\Commands;

use App\Mail\EmailSieteDias;
use App\Models\SolicitudFirma;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class FirmaSieteDiasVencen extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'day:email_siete';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Envia un email 7 dias antes de que la firma digital venza';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $solicitudes=SolicitudFirma::with('estado','entidad.contacto')->whereHas('estado',function($q){
            $q->where('fecha_vencimiento',Carbon::now()->addDays(6)->format('Y-m-d'));
          })->get();
          echo $solicitudes;
          foreach($solicitudes as $solicitud){
              Mail::to($solicitud->eMail)->send(new EmailSieteDias($solicitud));
              $this->info('Email enviado correctamente');
          }
    }
}
