<?php

namespace App\Http\Controllers;

use App\Http\Requests\AccionRequest;
use App\Repositories\AccionRepository;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class AccionController extends Controller
{
    private AccionRepository $accion;
    public function __construct(AccionRepository $accion) 
    {
        $this->accion = $accion;
        $this->middleware('auth:api');
    }

    public function crearAccion(AccionRequest $request){
        try {
            $accion = $this->accion->create($request->all());
            return response()->json([
                'status'=>200,
                'message'=>'Accion creada correctamente.',
                'data'=>$accion->load('solicitud','usuario_registra')
            ],200);
        } catch (\Throwable $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$th->getMessage()
            ],400);
        }
    }
    public function listarAcciones(Request $request){
        try {
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $acciones = $this->accion->getAll($request);
            return ($acciones->count()>0)?
            response()->json([
                'status'=>200,
                'message'=>'Acciones listadas correctamente.',
                'data'=>$acciones
            ],200):
            response()->json([
                'status'=>200,
                'message'=>'No hay registro de Acciones.',
                'data'=>null
            ],200);
        } catch (\Throwable $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$th->getMessage()
            ],400);
        }
    }
    public function verAccion(){
        try {
            if(Str::isUuid(request()->route('id'))){
                $accion = $this->accion->getById(request()->route('id'));
                return ($accion)?
                response()->json([
                    'status'=>200,
                    'message'=>'Accion econtrada correctamente.',
                    'data'=>$accion
                ],200):
                response()->json([
                    'status'=>200,
                    'message'=>'No hay registro de Accion.',
                    'data'=>null
                ],200);
            }
            else{
                return response()->json([
                    'status'=>422,
                    'message'=>'El id de la Accion no es valido.',
                    'data'=>'Uuid invalido.'
                ],422);
            }

        } catch (\Throwable $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$th->getMessage()
            ],400);
        }
    }
    public function actualizarAccion(AccionRequest $request){
        try {
            // $this->authorize('actualizar-accion');
            if(Str::isUuid(request()->route('id'))){
                $accion = $this->accion->update(request()->route('id'),$request->all());
                return ($accion)?
                response()->json([
                    'status'=>200,
                    'message'=>'Accion actualizada correctamente.',
                    'data'=>$accion
                ],200):
                response()->json([
                    'status'=>200,
                    'message'=>'No hay registro de Accion.',
                    'data'=>null
                ],200);
            }
            else{
                return response()->json([
                    'status'=>422,
                    'message'=>'El id de la Accion no es valido.',
                    'data'=>'Uuid invalido.'
                ],422);
            }

        } catch (AuthorizationException $th) {
            return response()->json([
                'status'=>401,
                'message'=>'No tiene permisos!',
                'data'=>$th->getMessage()
            ],401);
        } catch (\Exception $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$th->getMessage()
            ],400);
        }
    }
    public function eliminarAccion(){
        try {
            // $this->authorize('eliminar-accion');
            if(Str::isUuid(request()->route('id'))){
                $accion = $this->accion->delete(request()->route('id'));
                return ($accion)?
                response()->json([
                    'status'=>200,
                    'message'=>'Accion eliminada correctamente.',
                    'data'=>$accion
                ],200):
                response()->json([
                    'status'=>200,
                    'message'=>'No hay registro de Accion.',
                    'data'=>null
                ],200);
            }
            else{
                return response()->json([
                    'status'=>422,
                    'message'=>'El id de la Accion no es valido.',
                    'data'=>'Uuid invalido.'
                ],422);
            }

        } catch(AuthorizationException $th) {
            return response()->json([
                'status'=>401,
                'message'=>'No tiene permisos!',
                'data'=>$th->getMessage()
            ],401);
        } catch (\Exception $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$th->getMessage()
            ],400);
        }
    }

    public function listarAccionesSolicitud(Request $request)
    {
        try {
            
            $acciones = $this->accion->getAccionSolicitud(request()->route('id'));
            return ($acciones->count()>0)?
            response()->json([
                'status'=>200,
                'message'=>'Acciones listadas correctamente.',
                'data'=>$acciones
            ],200):
            response()->json([
                'status'=>200,
                'message'=>'No hay registro de Acciones.',
                'data'=>null
            ],200);
        } catch (\Throwable $th) {
            return response()->json([
                'status'=>$th->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$th->getMessage()
            ],400);
        }
    }

}
