<?php

namespace App\Http\Controllers;

use App\Models\Contacto;
use App\Models\EntidadComercial;
use App\Models\Usuario;
use App\Repositories\ApiCoorporativoRepository;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ApiCoorporativoController extends Controller
{
    protected $apiCoorporativo;
    public function __construct(ApiCoorporativoRepository $apiCoorporativo)
    {
        $this->apiCoorporativo = $apiCoorporativo;
        $this->middleware('auth:api');
    }
    public function crearApiCoorporativo(Request $request)
    {
        try {
            // $this->authorize('registrar-api-coorporativo');
            $validator= Validator::make($request->all(),[
                'entidad_id' => 'required|exists:entidades_comerciales,id',
            ]);
            if($validator->fails()){
                return response()->json([
                    'status' => 422,
                    'message' => $validator->errors(),
                ], 422);
            }
            else{
                $apiCoorporativo = $this->apiCoorporativo->create($request->all())->load('entidad');
                $usuario=Usuario::create([
                    'nombre' => 'API Rest',
                    'apellido' => $apiCoorporativo->entidad->nombre_comercial,
                    'correo' => $apiCoorporativo->entidad->correo,
                    'correo_recuperacion' => $apiCoorporativo->entidad->correo,
                    'password' => bcrypt($apiCoorporativo->entidad_id),
                    'identificacion' => $apiCoorporativo->entidad_id,
                    'tipo_identificacion' => 'PASAPORTE',
                    'genero'=>'HOMBRE',
                    'usuario_registra'=>auth()->user()->id,
                    'tipo_usuario' => '4d8bb982-f6f6-4b34-8558-c0f1f5425922',
                    'estado'=>'1',
                    'cod_pais'=>'8705e1ad-b2b1-4c39-8884-377e5986fe6e',
                    'foto_perfil_url'=>$apiCoorporativo->entidad->logo
                ]);
               $contacto=Contacto::create([
                    'usuario_id' => $usuario->id,
                    'celular' => $apiCoorporativo->entidad->contacto->celular,
                    'whatsapp' => $apiCoorporativo->entidad->contacto->whatsapp,
                    'fijo' => $apiCoorporativo->entidad->contacto->fijo,
               ]); 
                return response()->json([
                    'status' => 201,
                    'message' => 'Api creada correctamente',
                    'data' => $apiCoorporativo,
                ], 201);
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos para crear la api',
                'data' => $th->getMessage(),
            ], 401);
        }catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Error al crear la api',
                'data' => $e->getMessage(),
            ], 400);
        }
    }
    public function listarApiCoorporativo(Request $request)
    {
        try {
            // $this->authorize('listar-api-coorporativo');
            $apiCoorporativo = $this->apiCoorporativo->getAll($request);
            return($apiCoorporativo->count()>0) ? response()->json([
                'status' => 200,
                'message' => 'Lista de apis',
                'data' => $apiCoorporativo,
            ], 200) : response()->json([
                'status' => 200,
                'message' => 'No hay apis registradas',
                'data' => null,
            ], 200);
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos!',
                'data' => $th->getMessage(),
            ], 401);
        }catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Error al listar las apis',
                'data' => $e->getMessage(),
            ], 400);
        }
    }
    public function verApiCoorporativo($id){
        try {
            // $this->authorize('ver-api-coorporativo');
            $apiCoorporativo = $this->apiCoorporativo->getById($id);
            return($apiCoorporativo) ? response()->json([
                'status' => 200,
                'message' => 'Api encontrada',
                'data' => $apiCoorporativo,
            ], 200) : response()->json([
                'status' => 200,
                'message' => 'No se encontro la api',
                'data' => null,
            ], 200);
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos para ver la api',
                'data' => $th->getMessage(),
            ], 401);
        }catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Error al ver la api',
                'data' => $e->getMessage(),
            ], 400);
        }
    }
    public function verApiCoorporativoEntidad($id){
        try {
            // $this->authorize('ver-api-coorporativo-entidad');
            $apiCoorporativo = $this->apiCoorporativo->getByIdEntidad($id);
            return($apiCoorporativo) ? response()->json([
                'status' => 200,
                'message' => 'Api encontrada',
                'data' => $apiCoorporativo,
            ], 200) : response()->json([
                'status' => 200,
                'message' => 'No se encontro la api',
                'data' => null,
            ], 200);
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos!',
                'data' => $th->getMessage(),
            ], 401);
        }catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Ocurrio un error!',
                'data' => $e->getMessage(),
            ], 400);
        }
    }
    public function actualizarApiCoorporativo(Request $request,$id){
        try {
            // $this->authorize('actualizar-api-coorporativo');
            $apiCoorporativo = $this->apiCoorporativo->updateEstadoById($id,$request->all());
            if($apiCoorporativo!=null){
                
                return response()->json([
                    'status' => 200,
                    'message' => 'Api actualizada correctamente',
                    'data' => $apiCoorporativo,
                ], 200);
            }
            else{
                return response()->json([
                    'status' => 200,
                    'message' => 'No se encontro la api',
                    'data' => null,
                ], 200);
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos para actualizar la api',
                'data' => $th->getMessage(),
            ], 401);
        }catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Error al actualizar la api',
                'data' => $e->getMessage(),
            ], 400);
        }
    }
    // public function actualizarClaveApiCoorporativo($id){
    //     try {
    //         // $this->authorize('actualizarClaveApi');
    //         $apiCoorporativo = $this->apiCoorporativo->updateClaveById($id);
    //         if($apiCoorporativo!=null){
    //             return response()->json([
    //                 'status' => 200,
    //                 'message' => 'Clave actualizada correctamente',
    //                 'data' => $apiCoorporativo,
    //             ], 200);
    //         }
    //         else{
    //             return response()->json([
    //                 'status' => 200,
    //                 'message' => 'No se encontro la api',
    //                 'data' => null,
    //             ], 200);
    //         }
    //     } catch (AuthorizationException $th) {
    //         return response()->json([
    //             'status' => $th->getCode(),
    //             'message' => 'No tiene permisos para actualizar la clave de la api',
    //             'data' => $th->getMessage(),
    //         ], 401);
    //     }catch (\Exception $e) {
    //         return response()->json([
    //             'status' => $e->getCode(),
    //             'message' => 'Error al actualizar la clave de la api',
    //             'data' => $e->getMessage(),
    //         ], 400);
    //     }
    // }

    public function enviarCredenciales(Request $request)
    {
        try {
            // $this->authorize('enviar-credenciales-api-coorporativo');
            $validator = Validator::make($request->all(), [
                'entidad_id'=>'required|exists:entidades_comerciales,id',

            ]);
            if ($validator->fails()) {
                return response()->json([
                    'status' => 422,
                    'message' => 'Error al validar datos',
                    'data' => $validator->errors(),
                ], 422);
            }
            else{
                $entidad=EntidadComercial::find($request->entidad_id)->load('api_coorporativo');
                $email=$this->apiCoorporativo->sendEmail($entidad,$request->correos);
                if($email){
                    return response()->json([
                        'status' => 200,
                        'message' => 'Credenciales enviadas correctamente',
                        'data' => $email,
                    ], 200);
                }
                else{
                    return response()->json([
                        'status' => 200,
                        'message' => 'No se encontro la api',
                        'data' => null,
                    ], 200);
                }
            }
        } catch (AuthorizationException $th) {
            return response()->json([
                'status' => $th->getCode(),
                'message' => 'No tiene permisos!',
                'data' => $th->getMessage(),
            ], 401);
        }catch (\Exception $e) {
            return response()->json([
                'status' => $e->getCode(),
                'message' => 'Error al enviar las credenciales',
                'data' => $e->getMessage(),
            ], 400);
        }
    }

    
}
