<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Password;

class ResetPasswordController extends Controller
{
    use ResetsPasswords;

    protected function sendResetResponse(Request $request, $response)
    {
        return new JsonResponse(['message' => trans($response)], 200);
    }

    protected function sendResetFailedResponse(Request $request, $response)
    {
        return new JsonResponse(['error' => trans($response)], 400);
    }

    protected function resetPassword($user, $password)
    {
        $user->password = Hash::make($password);
        $user->save();
        $user->tokens()->delete();
        $this->guard()->login($user);
    }

    protected function sendResetResponse(Request $request, $response)
    {
        return new JsonResponse(['message' => trans($response)], 200);
    }

    public function broker()
    {
        return Password::broker();
    }

    public function showResetForm(Request $request, $token = null)
    {
        return abort(404);
    }
}
