<?php

namespace App\Http\Controllers;

use App\Repositories\AccionRepository;
use App\Repositories\EstadoSolicitudRepository;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class EstadoSolicitudController extends Controller
{
    private $estado;
    private $accion;
    public function __construct(EstadoSolicitudRepository $estado,AccionRepository $accion)
    {
        $this->estado = $estado;
        $this->accion = $accion;
        $this->middleware('auth:api');
    }

    public function actualizarEstadoSolicitud(Request $request){
        try {
            // $this->authorize('actualizar-estadoSolicitud');
            if(Str::isUuid(request()->route('id'))){
                $estado_solicitud=$this->estado->update(request()->route('id'),$request->all());
                if($estado_solicitud==null){
                    return response()->json([
                        'status'=>404,
                        'message'=>'No se encontro el estado de la solicitud',
                        'data'=>null
                    ],404);
                }
                else{
                    $accion_nueva=$this->accion->create([
                        'solicitud_id'=>$estado_solicitud->solicitud_id,
                        'nombre_accion'=>'Actualizar estado de la solicitud',
                        'descripcion'=>'Se actualizo el los campos del Estado de la solicitud:'.implode(", ",$request->all())
                    ]);
                    return response()->json([
                        'status'=>200,
                        'message'=>'Se actualizo correctamente el estado de la solicitud',
                        'data'=>$estado_solicitud
                    ],200);
                }
            }
            else
            {
                return response()->json([
                    'status'=>422,
                    'message'=>'El id de la solicitud no es valido',
                    'data'=>'Uuid invalido'
                ],422);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status'=>401,
                'message'=>'No tiene permisos!',
                'data'=>$ae->getMessage()
            ],401);
        } catch (\Exception $e) {
            return response()->json([
                'status'=>400,
                'message'=>'Error al actualizar el estado de la solicitud',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function actualizarEstadoSolicitudEntidad(Request $request)
    {
        try {
            // $this->authorize('actualizar-estadoSolicitud-entidad');
            if(Str::isUuid(request()->route('id'))){
                $estado_solicitud=$this->estado->updateEstadoEntidad(request()->route('id'),$request->all());
                if($estado_solicitud==null){
                    return response()->json([
                        'status'=>404,
                        'message'=>'No se encontro el estado de la solicitud',
                        'data'=>null
                    ],404);
                }
                else{
                    $accion_nueva=$this->accion->create([
                        'solicitud_id'=>$estado_solicitud->solicitud_id,
                        'nombre_accion'=>'Actualizar estado de la solicitud',
                        'descripcion'=>'Se actualizo el los campos del Estado de la solicitud:'.implode(", ",$request->all())
                    ]);
                    return response()->json([
                        'status'=>200,
                        'message'=>'Se actualizo correctamente el estado de la solicitud',
                        'data'=>$estado_solicitud
                    ],200);
                }
            }
            else
            {
                return response()->json([
                    'status'=>422,
                    'message'=>'El id de la solicitud no es valido',
                    'data'=>'Uuid invalido'
                ],422);
            }
        } catch (AuthorizationException $ae) {
            return response()->json([
                'status'=>401,
                'message'=>'No tiene permisos!',
                'data'=>$ae->getMessage()
            ],401);
        } catch (\Exception $e) {
            return response()->json([
                'status'=>400,
                'message'=>'Error al actualizar el estado de la solicitud',
                'data'=>$e->getMessage()
            ],400);
        }
    }
}
