<?php

namespace App\Http\Controllers;

use App\Http\Requests\FirmaEmpresarialRequest;
use App\Repositories\FirmaEmpresarialRepository;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class FirmaEmpresarialController extends Controller
{
    private $firma;
    
    public function __construct(FirmaEmpresarialRepository $firma) 
    {
        $this->firma = $firma;
        $this->middleware('auth:api');
    }

    public function crearFirmaEmpresarial(FirmaEmpresarialRequest $request)
    {
        try {
            // $this->authorize('registrar-firma-empresarial');
            $firma_empresarial=$this->firma->create($request->all());
            return response()->json([
                'status'=>201,
                'message'=>'Se creo correctamente la Firma Empresarial',
                'data'=>$firma_empresarial->load('solicitud')
            ],201);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$e->getMessage()
            ],400);
        }
    }
    public function listarFirmasEmpresariales(Request $request){
        try {
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $firmas_empresariales = $this->firma->getAll($request);
            if ($firmas_empresariales->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Listado de firmas empresariales.',
                    'data' => $firmas_empresariales
                ],200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No existen firmas empresariales registradas.',
                    'data' => null
                ],200);
            }
        } catch (Exception $th) {
           return response()->json([
                'status' =>$th->getCode() ,
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ],400);
        }
    }
    public function verFirmaEmpresarial(){
        try {
            if (Str::isUuid(request()->route('id'))) {
                $firma_empresarial=$this->firma->getById(request()->route('id'));
                if ($firma_empresarial) {
                    return response()->json([
                        'status' => 200,
                        'message' => 'Firma Empresarial.',
                        'data' => $firma_empresarial->load('solicitud')
                    ],200);
                } else {
                    return response()->json([
                        'status' => 200,
                        'message' => 'No existe la firma empresarial.',
                        'data' => null
                    ],200);
                }
            } else {
                return response()->json([
                    'status' => 422,
                    'message' => 'El id de la firma empresarial no es valido.',
                    'data' => 'Uuid no valido.'
                ],422);
            }
        } catch (Exception $th) {
            return response()->json([
                'status' =>$th->getCode() ,
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ],400);
        }
    }
    public function actualizarFirmaEmpresarial(Request $request){
        try {
            if (Str::isUuid(request()->route('id'))) {
                $firma_empresarial=$this->firma->update(request()->route('id'),$request->all());
                if ($firma_empresarial) {
                    return response()->json([
                        'status' => 200,
                        'message' => 'Firma Empresarial actualizada.',
                        'data' => $firma_empresarial->load('solicitud')
                    ],200);
                } else {
                    return response()->json([
                        'status' => 200,
                        'message' => 'No existe la firma empresarial.',
                        'data' => null
                    ],200);
                }
            } else {
                return response()->json([
                    'status' => 422,
                    'message' => 'El id de la firma empresarial no es valido.',
                    'data' => 'Uuid no valido.'
                ],422);
            }
        } catch (Exception $th) {
            return response()->json([
                'status' =>$th->getCode() ,
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ],400);
        }
    }

    public function listarFirmasEmpresarialesEntidad(Request $request)
    {
        try {
            // $this->authorize('listar-firmas-empresarial-entidad');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $firmas = $this->firma->getFirmasEntidad($request);
            if ($firmas->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Listado de firmas Empresarial.',
                    'data' => $firmas
                ],200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No existen firmas de representante empresarial registradas.',
                    'data' => null
                ],200);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function listarFirmasEmpresarialesUsuario(Request $request)
    {
        try {
            // $this->authorize('listar-firmas-empresarial-usuario');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $firmas = $this->firma->getFirmasUsuario($request);
            if ($firmas->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Listado de firmas Empresarial.',
                    'data' => $firmas
                ],200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No existen firmas de representante empresarial registradas.',
                    'data' => null
                ],200);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function actualizarFirmaEmpresarialEntidad(Request $request,$id)
    {
        try {
            // $this->authorize('actualizar-firma-empresarial-entidad');
            $firma=$this->firma->updateFirmaEntidad($id,$request->all());
            if($firma==null){
                return response()->json([
                    'status' => 200,
                    'message' => 'No existe la firma empresarial.',
                    'data' => null
                ],200);
            }
            else{
                return response()->json([
                    'status' => 200,
                    'message' => 'Firma empresarial actualizada.',
                    'data' => $firma
                ],200);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function actualizarFirmaEmpresarialUsuario(Request $request,$id)
    {
        try {
            // $this->authorize('actualizar-firma-empresarial-usuario');
            $firma=$this->firma->updateFirmaUsuario($id,$request->all());
            if($firma==null){
                return response()->json([
                    'status' => 200,
                    'message' => 'No existe la firma empresarial.',
                    'data' => null
                ],200);
            }
            else{
                return response()->json([
                    'status' => 200,
                    'message' => 'Firma empresarial actualizada.',
                    'data' => $firma
                ],200);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }
    
}
