<?php

namespace App\Http\Controllers;

use App\Http\Requests\FirmaJuridicaRequest;
use App\Repositories\FirmaJuridicaRepository;
use App\Repositories\FirmaRepresentanteLegalRepository;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class FirmaJuridicaController extends Controller
{
    private $firma;
    
    public function __construct(FirmaJuridicaRepository $firma) 
    {
        $this->firma = $firma;
        $this->middleware('auth:api');
    }

    public function crearFirmaJuridica(FirmaJuridicaRequest $request)
    {
        try {
            $firma_juridica=$this->firma->create($request->all());
            return response()->json([
                'status'=>201,
                'message'=>'Se creo correctamente la Firma Juridica',
                'data'=>$firma_juridica->load('solicitud')
            ],201);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function listarFirmasJuridicas(Request $request){
        try {
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $firmas_juridicas = $this->firma->getAll($request);
            if ($firmas_juridicas->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Listado de firmas juridicas.',
                    'data' => $firmas_juridicas
                ],200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No existen firmas juridicas registradas.',
                    'data' => null
                ],200);
            }
        } catch (Exception $th) {
           return response()->json([
                'status' =>$th->getCode() ,
                'message' => 'Error al listar firmas juridicas.',
                'data' => $th->getMessage()
            ],400);
        }
    }

    public function verFirmaJuridica(){
        try{
            if(Str::isUuid(request()->route('id'))){
                $firma_juridica=$this->firma->getById(request()->route('id'));
                if($firma_juridica){
                    return response()->json([
                        'status'=>200,
                        'message'=>'Firma juridica encontrada.',
                        'data'=>$firma_juridica->load('solicitud')
                    ],200);
                }else{
                    return response()->json([
                        'status'=>200,
                        'message'=>'No existe la firma juridica indicada.',
                        'data'=>null
                    ],200);
                }
            }
            else{
                return response()->json([
                    'status'=>422,
                    'message'=>'El id de la firma juridica no es valido.',
                    'data'=>'UUID Formato incorrecto.'
                ],422);

            }
        }catch(Exception $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function actualizarFirmaJuridica(Request $request){
        try{
            if(Str::isUuid(request()->route('id'))){
                $firma_juridica=$this->firma->update(request()->route('id'),$request->all());
                if($firma_juridica){
                    return response()->json([
                        'status'=>200,
                        'message'=>'Firma juridica actualizada.',
                        'data'=>$firma_juridica->load('solicitud')
                    ],200);
                }else{
                    return response()->json([
                        'status'=>200,
                        'message'=>'No existe la firma juridica indicada.',
                        'data'=>null
                    ],200);
                }
            }
            else{
                return response()->json([
                    'status'=>422,
                    'message'=>'El id de la firma juridica no es valido.',
                    'data'=>'UUID Formato incorrecto.'
                ],422);

            }
        }catch(Exception $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error!.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function listarFirmasJuridicasEntidad(Request $request)
    {
        try {
            // $this->authorize('listar-firmas-juridica-entidad');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $firmas = $this->firma->getFirmasEntidad($request);
            if ($firmas->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Listado de firmas Juridicas.',
                    'data' => $firmas
                ],200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No existen firmas juridicas registradas.',
                    'data' => null
                ],200);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function listarFirmasJuridicasUsuario(Request $request)
    {
        try {
            // $this->authorize('listar-firmas-juridica-usuario');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $firmas = $this->firma->getFirmasUsuario($request);
            if ($firmas->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Listado de firmas Juridicas.',
                    'data' => $firmas
                ],200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No existen firmas juridicas registradas.',
                    'data' => null
                ],200);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function actualizarFirmaJuridicaEntidad(Request $request,$id)
    {
        try {
            // $this->authorize('actualizar-firma-juridica-entidad');
            $firma=$this->firma->updateFirmaEntidad($id,$request->all());
            if($firma==null){
                return response()->json([
                    'status' => 200,
                    'message' => 'No existe la firma juridica indicada.',
                    'data' => null
                ],200);
            }
            else{
                return response()->json([
                    'status' => 200,
                    'message' => 'Firma juridica actualizada.',
                    'data' => $firma
                ],200);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function actualizarFirmaJuridicaUsuario(Request $request,$id)
    {
        try {
            // $this->authorize('actualizar-firma-juridica-usuario');
            $firma=$this->firma->updateFirmaUsuario($id,$request->all());
            if($firma==null){
                return response()->json([
                    'status' => 200,
                    'message' => 'No existe la firma juridica indicada.',
                    'data' => null
                ],200);
            }
            else{
                return response()->json([
                    'status' => 200,
                    'message' => 'Firma juridica actualizada.',
                    'data' => $firma
                ],200);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }
}
