<?php

namespace App\Http\Controllers;


use App\Http\Requests\FirmaRepresentanteLegalRequest;
use App\Models\FirmaRepresentanteLegal;
use App\Repositories\FirmaRepresentanteLegalRepository;
use Exception;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class FirmaRepresentanteLegalController extends Controller
{
    private $firma;
    
    public function __construct(FirmaRepresentanteLegalRepository $firma) 
    {
        $this->firma = $firma;
        $this->middleware('auth:api');
    }
    
    public function listarFirmasRepresentanteLegal(Request  $request)
    {
        try {
            // $this->authorize('listar-firmas-representante');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $firmas = $this->firma->getAll($request);
            if ($firmas->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Listado de firmas de representante legal.',
                    'data' => $firmas
                ],200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No existen firmas de representante legal registradas.',
                    'data' => null
                ],200);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    
    public function crearFirmaRepresentanteLegal(FirmaRepresentanteLegalRequest $request)
    {
        try {
            // $this->authorize('registrar-firma-representante');
            $firma_rl=$this->firma->create($request->all());
            return response()->json([
                'status'=>201,
                'message'=>'Se creo correctamente la Firma de Representante Legal',
                'data'=>$firma_rl->load('solicitud')
            ],201);
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    
    public function verFirmaRepresentanteLegal($id)
    {
        try {
            if (Str::isUuid($id)==true) {
                $firma_rl=$this->firma->getById($id);
                return ($firma_rl!=null) ? 
                response()->json([
                    'status'=>200,
                    'message'=>'Solicitud de Firma Representante Legal indicado.',
                    'data'=>$firma_rl
                ],200) :
                response()->json([
                    'status'=>200,
                    'message'=>'No se encontro la Solicitud de Firma Representante Legal.',
                    'data'=>null
                ],200);
            } else {
                return response()->json([
                    'status'=>422,
                    'message'=>'El id ingresado es incorrecto.',
                    'data'=>'UUID Formato incorrecto.'
                ],422);
            }
            
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function actualizarFirmaRepresentanteLegal(Request $request, $id)
    {
        try {
            // $this->authorize('actualizar-firma-representante');
            if (Str::isUuid($id)==true) {
                $firma_rl=$this->firma->update($id,$request->all());
                return response()->json([
                    'status'=>200,
                    'message'=>'Se actualizo correctamente los datos de solicitud de firma de representante legal.',
                    'data'=>$firma_rl
                ]);
            } else {
                return response()->json([
                    'status'=>422,
                    'message'=>'El id ingresado es incorrecto.',
                    'data'=>'UUID Formato incorrecto.'
                ],422);
            }
            
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    
    public function destroy(FirmaRepresentanteLegal $firmaRepresentanteLegal)
    {
        //
    }

    public function listarFirmasRepresentanteEntidad(Request $request)
    {
        try {
            // $this->authorize('listar-firmas-representante-entidad');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $firmas = $this->firma->getFirmasEntidad($request);
            if ($firmas->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Listado de firmas de representante legal.',
                    'data' => $firmas
                ],200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No existen firmas de representante legal registradas.',
                    'data' => null
                ],200);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function listarFirmasRepresentanteUsuario(Request $request)
    {
        try {
            // $this->authorize('listar-firmas-representante-usuario');
            $request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $firmas = $this->firma->getFirmasUsuario($request);
            if ($firmas->count() > 0) {
                return response()->json([
                    'status' => 200,
                    'message' => 'Listado de firmas de representante legal.',
                    'data' => $firmas
                ],200);
            } else {
                return response()->json([
                    'status' => 200,
                    'message' => 'No existen firmas de representante legal registradas.',
                    'data' => null
                ],200);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function actualizarFirmaRepresentanteEntidad(Request $request, $id)
    {
        try {
            // $this->authorize('actualizar-firma-representante-entidad');
            $firma_rl=$this->firma->updateFirmaEntidad($id,$request->all());
            if ($firma_rl==null) {
                return response()->json([
                    'status'=>200,
                    'message'=>'No se encontro datos de solicitud de firma de representante legal.',
                    'data'=>$firma_rl
                ],200);
            } else {
                return response()->json([
                    'status'=>200,
                    'message'=>'Se actualizo correctamente los datos de solicitud de firma de representante legal.',
                    'data'=>$firma_rl
                ]);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

    public function actualizarFirmaRepresentanteUsuario(Request $request, $id)
    {
        try {
            // $this->authorize('actualizar-firma-representante-usuario');
            $firma_rl=$this->firma->updateFirmaUsuario($id,$request->all());
            if ($firma_rl==null) {
                return response()->json([
                    'status'=>200,
                    'message'=>'No se encontro datos de solicitud de firma de representante legal.',
                    'data'=>$firma_rl
                ],200);
            } else {
                return response()->json([
                    'status'=>200,
                    'message'=>'Se actualizo correctamente los datos de solicitud de firma de representante legal.',
                    'data'=>$firma_rl
                ]);
            }
        } catch(AuthorizationException $e){
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'No tiene permisos!.',
                'data'=>$e->getMessage()
            ],401);
        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }
}
