<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class ProxyController extends Controller
{
    public function proxyToFirmas(Request $request, $url)
    {
        $decodedUrl = urldecode($url);

        // Base de headers
        $headers = [
            'Content-Type' => 'application/json',
        ];

        // Si el endpoint contiene firmaclientes/solicitud/distrapi => primero loguearse
        if (str_contains($decodedUrl, 'firmaclientes/solicitud/distrapi')) {
            try {
                $loginResponse = Http::withHeaders([
                    'Content-Type' => 'application/json',
                ])->post('https://newsignapidev.newbest.net/newsignapi/login', [
                    "identificacion_usuario" => "0604176289",
                    "username_usuario"       => "tfirmaec",
                    "password_usuario"       => "123456",
                ]);
                $decodedUrl='https://newsignapidev.newbest.net/newsignapi/chatbot/chatbotclientes';

                if ($loginResponse->successful() && isset($loginResponse['token'])) {
                    // Agregar el token a los headers
                    $headers['Authorization'] = 'Bearer ' . $loginResponse['token'];
                } else {
                   /* $headers['Authorization'] = 'Bearer ' . 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZGVudGlmaWNhY2lvbl91c3VhcmlvIjoiMDYwNDE3NjI4OSIsInVzZXJuYW1lX3VzdWFyaW8iOiJ0ZmlybWFlYyIsImlhdCI6MTc1ODExODQ2MywiZXhwIjoxNzU4MjA0ODYzfQ.nXvgqXoCJjjIRHwAVxofbxjeg5t7rppmPBOrZYeqSPM';*/
                    return response()->json([
                        'error' => 'Error en autenticacin',
                        'message' =>mb_convert_encoding($loginResponse->body(), 'UTF-8', 'UTF-8'),
                    ], $loginResponse->status());
                }
                
            }  catch (\Exception $e) {
                return response()->json([
                    'error' => 'Error al autenticar',
                    'message' => $e->getMessage().'||1||',
                ], 500);
            }
        } else {
            // Si viene con token desde el cliente
            $bearerToken = $request->bearerToken();
            if ($bearerToken) {
                $headers['Authorization'] = 'Bearer ' . $bearerToken;
            }
        }

        // Proxy a la URL final
        try {
            $response = Http::withHeaders($headers)->send($request->method(), $decodedUrl, [
                'query' => $request->query(),
                'json'  => $request->all(),
            ]);

            return response($response->body(), $response->status())
                ->withHeaders($response->headers());
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Error al contactar con el servicio externo',
                'message' => $e->getMessage().'||2||'.$loginResponse['token'],
            ], 500);
        }
    }
}

