<?php

namespace App\Http\Controllers;

use App\Models\RegistroLote;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;

class RegistroLoteController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function listar(Request $request)
    {
        try {
            // $this->authorize('listar-registro-lotes');
            $pag=$request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $lst_registro=RegistroLote::with('usuario_registra','entidad_id')->paginate($pag->query('per_page', 10));
            if($lst_registro->count()==0){
                return response()->json([
                    'status'=>200,
                    'message'=>'No hay registros',
                    'data'=>null
                ]);
            }
            else{
                return response()->json([
                    'status'=>200,
                    'message'=>'Listado de registros de lotes encontrados.',
                    'data'=>$lst_registro
                ]);
            }
        } catch (AuthorizationException $e) {
            return response()->json([
                'status'=>403,
                'message'=>'No tiene permisos!',
                'data'=>$e->getMessage()
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status'=>400,
                'message'=>'Ocurrio y error',
                'data'=>$e->getMessage()
            ],400);
        }
        
    }
    public function listarEntidad(Request $request)
    {
        try {
            // $this->authorize('listar-registro-lotes-entidad');
            $pag=$request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $lst_registro=RegistroLote::with('usuario_registra','entidad_id')
            ->where('entidad_id',auth()->user()->entidad_id)
            ->paginate($pag->query('per_page', 10));
            if($lst_registro->count()==0){
                return response()->json([
                    'status'=>200,
                    'message'=>'No hay registros',
                    'data'=>null
                ]);
            }
            else{
                return response()->json([
                    'status'=>200,
                    'message'=>'Listado de registros de lotes encontrados.',
                    'data'=>$lst_registro
                ]);
            }
        } catch (AuthorizationException $e) {
            return response()->json([
                'status'=>403,
                'message'=>'No tiene permisos!',
                'data'=>$e->getMessage()
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status'=>400,
                'message'=>'Ocurrio y error',
                'data'=>$e->getMessage()
            ],400);
        }
        
    }
    public function listarUsuario(Request $request)
    {
        try {
            // $this->authorize('listar-registro-lotes-usuario');
            $pag=$request->merge([
                'page' => $request->input('page', 0) + 1
            ]);
            $lst_registro=RegistroLote::with('usuario_registra','entidad_id')
            ->where('usuario_registra',auth()->user()->id)
            ->paginate($pag->query('per_page', 10));
            if($lst_registro->count()==0){
                return response()->json([
                    'status'=>200,
                    'message'=>'No hay registros',
                    'data'=>null
                ]);
            }
            else{
                return response()->json([
                    'status'=>200,
                    'message'=>'Listado de registros de lotes encontrados.',
                    'data'=>$lst_registro
                ]);
            }
        } catch (AuthorizationException $e) {
            return response()->json([
                'status'=>403,
                'message'=>'No tiene permisos!',
                'data'=>$e->getMessage()
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status'=>400,
                'message'=>'Ocurrio y error',
                'data'=>$e->getMessage()
            ],400);
        }
        
    }
}
