<?php

namespace App\Http\Controllers;

use App\Repositories\AccionRepository;
use App\Repositories\EstadoSolicitudRepository;
use App\Repositories\SolicitudFirmaRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SolicitudFirmaPublicaController extends Controller
{
    public function __construct(SolicitudFirmaRepository $solicitud_firma, EstadoSolicitudRepository $estado, AccionRepository $accion)
    {
        $this->solicitud_firma = $solicitud_firma;
        $this->estado = $estado;
        $this->accion = $accion;
        //$this->middleware('auth:api');
    }
    public function verSolicitudFirma($solicitudFirma_id)
    {
        try {
            if (Str::isUuid($solicitudFirma_id)==true) {
                $solicitud=$this->solicitud_firma->getById($solicitudFirma_id);
                return ($solicitud!=null) ?
                    response()->json([
                        'status'=>200,
                        'message'=>'Solicitud de Firma indicado.',
                        'data'=>$solicitud
                    ],200) :
                    response()->json([
                        'status'=>200,
                        'message'=>'No se encontro la Solicitud de Firma.',
                        'data'=>null
                    ],200);
            } else {
                return response()->json([
                    'status'=>422,
                    'message'=>'El id ingresado es incorrecto.',
                    'data'=>'UUID Formato incorrecto.'
                ],422);
            }

        } catch (Exception $e) {
            return response()->json([
                'status'=>$e->getCode(),
                'message'=>'Ocurrio un error.',
                'data'=>$e->getMessage()
            ],400);
        }
    }

}
