<?php

namespace App\Http\Controllers;

use App\Models\SolicitudLote;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\Request;

class SolicitudLoteController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function listar(Request $resquet)
    {
        try {
            // $this->authorize('listar-solicitudes-lotes');
            $pag = $resquet->merge([
                'page' => $resquet->input('page', 0) + 1
            ]);
            $lst_solicitudes = SolicitudLote::with('solicitud_id.firmaRL','solicitud_id.firmaEmpresarial','solicitud_id.firmaJuridica','solicitud_id.estado')->where('lote_id',request()->route('id'))->paginate($pag->query('per_page', 10));
            if($lst_solicitudes->isEmpty()){
                return response()->json([
                    'status' => 404,
                    'message' => 'No se encontraron solicitudes.',
                    'data' => null
                ], 404);
            }
            else{
                return response()->json([
                    'status' => 200,
                    'message' => 'Solicitudes del lote.',
                    'data' => $lst_solicitudes
                ], 200);
            }
        } catch (AuthorizationException $e) {
            return response()->json([
                'status' => 401,
                'message' => 'No tiene permisos!',
                'data' => $e->getMessage()
            ],401);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 400,
                'message' => 'Ocurrio y error',
                'data' => $e->getMessage()
            ], 400);
        }
    }
    public function listarEntidad(Request $resquet)
    {
        try {
            // $this->authorize('listar-solicitudes-lotes-entidad');
            $pag = $resquet->merge([
                'page' => $resquet->input('page', 0) + 1
            ]);
            $lst_solicitudes = SolicitudLote::with('solicitud_id.firmaRL','solicitud_id.firmaEmpresarial','solicitud_id.firmaJuridica','solicitud_id.estado')->
            whereHas('solicitud_id', function ($query) {
                $query->where('entidad_solicitante', auth()->user()->entidad_id);
            })->
            where('lote_id',request()->route('id'))->paginate($pag->query('per_page', 10));
            if($lst_solicitudes->isEmpty()){
                return response()->json([
                    'status' => 404,
                    'message' => 'No se encontraron solicitudes.',
                    'data' => null
                ], 404);
            }
            else{
                return response()->json([
                    'status' => 200,
                    'message' => 'Solicitudes del lote.',
                    'data' => $lst_solicitudes
                ], 200);
            }
        } catch (AuthorizationException $e) {
            return response()->json([
                'status' => 401,
                'message' => 'No tiene permisos!',
                'data' => $e->getMessage()
            ],401);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 400,
                'message' => 'Ocurrio y error',
                'data' => $e->getMessage()
            ], 400);
        }
    }
    public function listarUsuario(Request $resquet)
    {
        try {
            // $this->authorize('listar-solicitudes-lotes-usuario');
            $pag = $resquet->merge([
                'page' => $resquet->input('page', 0) + 1
            ]);
            $lst_solicitudes = SolicitudLote::with('solicitud_id.firmaRL','solicitud_id.firmaEmpresarial','solicitud_id.firmaJuridica','solicitud_id.estado')->
            whereHas('solicitud_id', function ($query) {
                $query->where('usuario_solicita', auth()->user()->id);
            })->
            where('lote_id',request()->route('id'))->paginate($pag->query('per_page', 10));
            if($lst_solicitudes->isEmpty()){
                return response()->json([
                    'status' => 404,
                    'message' => 'No se encontraron solicitudes.',
                    'data' => null
                ], 404);
            }
            else{
                return response()->json([
                    'status' => 200,
                    'message' => 'Solicitudes del lote.',
                    'data' => $lst_solicitudes
                ], 200);
            }
        } catch (AuthorizationException $e) {
            return response()->json([
                'status' => 401,
                'message' => 'No tiene permisos!',
                'data' => $e->getMessage()
            ],401);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 400,
                'message' => 'Ocurrio y error',
                'data' => $e->getMessage()
            ], 400);
        }
    }
}
