<?php

namespace App\Http\Controllers;

use App\Models\TipoUsuario;
use Illuminate\Http\Request;

class TipoUsuarioController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:api');
    }
    public function listarTiposUsuarios()
    {
        try {
            $tipos = TipoUsuario::all();
            return ($tipos != null) ?
                response()->json([
                    'status' => 200,
                    'message' => 'Listado de Tipos de Usuario.',
                    'data' => $tipos
                ]) :
                response()->json([
                    'status' => 200,
                    'message' => 'No hay Tipos de Usuarios Registrados.',
                    'data' => null
                ]);
        } catch (\Throwable $th) {
            response()->json([
                'status' => $th->getCode(),
                'message' => 'Ocurrio un error!.',
                'data' => $th->getMessage()
            ],400);
        }
    }
}
