<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ApiCoorporativo extends Model
{
    use HasFactory,Uuid;
    protected $table = 'api_coorporativos';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable =[
        'entidad_id',
        'estado',
        'token',
        'clave_coorporativo',
        'url_acceso',
    ];
    
    public function entidad():BelongsTo
    {
        return $this->belongsTo(EntidadComercial::class,'entidad_id');
    }

}
