<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AppVersion extends Model
{
    use HasFactory, Uuid;
    protected $table = 'app_version';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable = [
        'codigo_version',
        'descripcion',
        'fecha_creacion',
        'responsable',
        'estado',
        'url_apk',
        'fecha',
    ];
}
