<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Contacto extends Model
{
    use HasFactory,Uuid;
    protected $table = 'contactos';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable =[
        'entidad_id',
        'celular',
        'fijo',
        'whatsapp',
        'usuario_id'
    ];

    protected $hidden = [
        'entidad_id',
        'usuario_id'
        
    ];

    public function entidad_id(): BelongsTo
    {
        return $this->belongsTo(EntidadComercial::class,'entidad_id');
       
    }

    public function usuario_id(): BelongsTo
    {
        return $this->belongsTo(Usuario::class,'usuario_id');
       
    }
}
