<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Dispositivo extends Model
{
    use HasFactory, Uuid;
    protected $table = 'dispositivo';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable = [
        'entidad_id',
        'ultima_conexion',
        'nombre_dispositivo',
        'ubicacion',
        'observaciones_diagnostico',
        'estado',
        'estado_diagnostico',
        'version_apk_instalada',
        'ip_publica',
        'codigo_remoto',
        'herramienta_remoto',
        'token_push_FCM',
    ];

    public function entidad(): BelongsTo
    {
        return $this->belongsTo(EntidadComercial::class, 'entidad_id');
    }
}
