<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class EntidadComercial extends Model
{
    use HasFactory, Uuid;
    protected $table = 'entidades_comerciales';
    public $incrementing = false;
    protected $keyType = 'uuid';
    // protected $appends = ['usuario_registra'];
    protected $fillable = [
        'ruc_empresa',
        'nombre_completo',
        'nombre_comercial',
        'correo',
        'direccion',
        'telefono',
        'logo',
        'correo_coorporativo',
        'fecha_registro',
        'usuario_registra',
        'tipo_entidad',
        'estado',
    ];


    public function entidadComercial()
    {
        return $this->belongsTo(EntidadComercial::class);
    }
    public function contacto(): HasOne
    {
        return $this->hasOne(Contacto::class, 'entidad_id');
    }

    public function usuario(): HasMany
    {
        return $this->hasMany(Usuario::class, 'entidad_id');
    }

    public function interfaz(): HasOne
    {
        return $this->hasOne(InterfazEntidadComercial::class, 'entidad_id');
    }

    public function api_coorporativo(): HasOne
    {
        return $this->hasOne(ApiCoorporativo::class, 'entidad_id');
    }

    public function solicitud(): HasMany
    {
        return $this->hasMany(SolicitudFirma::class, 'entidad_solicitante');
    }

    public function registro_lote(): HasOne
    {
        return $this->hasOne(RegistroLote::class, 'entidad_id');
    }

    // public function getUsuarioRegistraAttribute($id){
    //     return Usuario::where('id',$id)->first();
    // }

    // public function getInformacion(){
    //     return $this->getusuario_registraAttribute($this->usuario_registra);
    // }

    public function solicitudes_iniciales(): HasMany
    {
        return $this->hasMany(SolicitudesIniciales::class);
    }
}
