<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class InterfazEntidadComercial extends Model
{
    use HasFactory,Uuid;
    protected $table='interfaz_entidad_comercial';
    public $incrementing=false;
    protected $krytype='uuid';

    protected $fillable=[
        'entidad_id',
        'url_logo',
        'color_principal',
        'color_secundario',
        'color_gradient',
        'slug'
    ];

    public function entidad(): BelongsTo
    {
        return $this->belongsTo(EntidadComercial::class,'entidad_id');
    }
}
