<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PagoPinpad extends Model
{
    use HasFactory, Uuid;
    protected $table = 'pagos_pinpad';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable = [
        'entidad_id',
        'valor_pagado',
        'fecha_pago',
        'usuario_registra',
        'tipo_pago',
        'comprobante_url',
        'descripcion',
        'validado',
        'usuario_valida',
        'solicitud_previa_id',
        'CodigoRespuesta',
        'RedAdquirente',
        'CodigoRespuestaAut',
        'Lote',
        'Hora',
        'Fecha',
        'Autorizacion',
        'TID',
        'MID',
        'NombreAdquirente',
        'TarjetaHabiente',
        'Referencia'
    ];

    public function entidad(): BelongsTo
    {
        return $this->belongsTo(EntidadComercial::class, 'entidad_id');
    }

    public function solicitudP(): BelongsTo
    {
        return $this->belongsTo(SolicitudPrevia::class, 'solicitud_previa_id');
    }
}
