<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class SolicitudFirma extends Model
{
    use HasFactory,Uuid;
    protected $table = 'solicitudes_firmas';
    public $incrementing = false;
    protected $keyType = 'uuid';

    protected $fillable =[
        'numerodocumento',
        'nombres',
        'apellido1',
        'apellido2',
        'tipodocumento',
        'tipo_solicitud',
        'coddactilar',
        'ruc_personal',
        'sexo',
        'contenedor',
        'fecha_nacimiento',
        'nacionalidad',
        'telfCelular',
        'telfFijo',
        'eMail',
        'telfCelular2',
        'provincia',
        'ciudad',
        'direccion',
        'vigenciafirma',
        'f_cedulaFront',
        'entidad_solicitante',
        'usuario_solicita',
        'f_cedulaBack',
        'f_selfie',
        'f_copiaruc',
        'f_adicional1',
        'f_adicional2',
        'f_adicional3',
        'f_adicional4',
        'firma_generada',
        'fecha_solicitud'

    ];

    public function firmaRL():HasOne
    {
        return $this->hasOne(FirmaRepresentanteLegal::class,'solicitud_id');
    }

    public function firmaEmpresarial():HasOne
    {
        return $this->hasOne(FirmaEmpresarial::class,'solicitud_id');
    }

    public function firmaJuridica():HasOne
    {
        return $this->hasOne(FirmaJuridica::class,'solicitud_id');
    }

    public function estado():HasOne
    {
        return $this->hasOne(EstadoSolicitud::class,'solicitud_id');
    }

    public function entidad():BelongsTo
    {
        return $this->belongsTo(EntidadComercial::class,'entidad_solicitante');
    }

    public function solicitud_lote():HasMany
    {
        return $this->hasMany(SolicitudLote::class,'solicitud_id');
    }
}
