<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\EntidadComercial;
use App\Models\Usuario;

class SolicitudPrevia extends Model
{
    use HasFactory, Uuid;
    protected $table = 'solicitudes_previas';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable = [
        'solicitud_id',
        'email',
        'identificacion',
        'telefono',
        'usuario_corp',
        'entidad_id',
        'estado',
        'contenedor',
        'requiere_facturacion',
        'numero_facturas',
        'requiere_firma',
        'vigenciafirma',
        'uanataca_id',
        'precio',
        'tipo_persona',
        'tipo_solicitud',
        'datos_persona'
    ];
    public function entidadComercial()
    {
        return $this->belongsTo(EntidadComercial::class, 'entidad_id');
    }

    public function usuario()
    {
        return $this->belongsTo(Usuario::class, 'usuario_corp');
    }
}
