<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class TipoUsuario extends Model
{
    use HasFactory,Uuid;
    protected $table = 'tipos_usuarios';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable =[
        'categoria',
        'subcategoria',
        'identificador'
    ];



    public function usuario(): HasMany
    {
        return $this->hasMany(Usuario::class);
    }
}
