<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Contracts\Auth\CanResetPassword;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Usuario extends Authenticatable implements JWTSubject,CanResetPassword
{
    use HasFactory,Uuid, Notifiable;
    protected $table = 'usuarios';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable =[
        'nombre',
        'apellido',
        'correo',
        'correo_recuperacion',
        'password',
        'identificacion',
        'tipo_identificacion',
        'genero',
        'usuario_registra',
        'tipo_usuario',
        'estado',
        'cod_pais',
        'foto_perfil_url',
        'entidad_id',
        'direccion' // Add direccion here
    ];

    protected $hidden = [
        'password',


    ];

    public function contacto():HasOne
    {
        return $this->hasOne(Contacto::class,'usuario_id');
    }

    public function claves():HasMany
    {
        return $this->hasMany(UsuarioClave::class);
    }

    public function tipo_usuario(): BelongsTo
    {
        return $this->belongsTo(TipoUsuario::class,'tipo_usuario');

    }
    public function cod_pais(): BelongsTo
    {
        return $this->belongsTo(CodigoPais::class,'cod_pais');
    }

    public function entidad_id(): BelongsTo
    {
        return $this->belongsTo(EntidadComercial::class,'entidad_id');
    }

    public function acciones():HasOne
    {
        return $this->hasOne(Accion::class,'usuario_registra');
    }

    public function registro_lote():HasOne
    {
        return $this->hasOne(RegistroLote::class,'usuario_registra');
    }


    /**
     * Get the identifier that will be stored in the subject claim of the JWT.
     *
     * @return mixed
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }

}
