<?php

namespace App\Models;

use App\Traits\Uuid;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UsuarioClave extends Model
{
    use HasFactory,Uuid;
    protected $table = 'usuarios_claves';
    public $incrementing = false;
    protected $keyType = 'uuid';
    protected $fillable =[
       'clave',
       'estado',
       'fecha',
       'usuario_id'
    ];

    public function usuario(): BelongsTo
    {
        return $this->belongsTo(Usuario::class);
       
    }
}
