<?php

namespace App\Providers;

use App\Interfaces\AccesoInterface;
use App\Interfaces\ApiCoorporativoInterface;
use App\Interfaces\EstadoSolicitudInterface;
use App\Interfaces\FirmaRepresentanteLegalInterface;
use App\Interfaces\SolicitudFirmaInterface;
use App\Interfaces\TipoFirmaRepositoryInterface;
use App\Repositories\FirmaRepresentanteLegalRepository;
use App\Repositories\SolicitudFirmaRepository;
use App\Repositories\TipoFirmaRepository;
use App\Repositories\AccesoRepository;
use App\Repositories\EstadoSolicitudRepository;
use Illuminate\Support\ServiceProvider;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(TipoFirmaRepositoryInterface::class,TipoFirmaRepository::class);
        $this->app->bind(AccesoInterface::class,AccessoRepository::class);
        $this->app->bind(SolicitudFirmaInterface::class,SolicitudFirmaRepository::class);
        $this->app->bind(FirmaInterface::class,FirmaRepresentanteLegalRepository::class);
        $this->app->bind(AccionInterface::class,AccionRepository::class);
        $this->app->bind(EstadoSolicitudInterface::class,EstadoSolicitudRepository::class);
        $this->app->bind(ApiCoorporativoInterface::class,ApiCoorporativoRepository::class);
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        //
    }
}
