<?php
namespace App\Repositories;

use App\Interfaces\AccesoInterface;
use App\Models\Acceso;


class AccesoRepository implements AccesoInterface
{
    public function getAllAccesos($data)
    {
        
        return Acceso::with('usuario.entidad_id','usuario.tipo_usuario')->orderBy('fecha','DESC')->paginate($data->query('per_page') ?? 10);
    }

    public function getAllAccesosEntidad($data)
    {
        return Acceso::with('usuario.entidad_id','usuario.tipo_usuario')->orderBy('fecha','DESC')
        ->whereHas('usuario',function($query){
            $query->where('entidad_id',auth()->user()->entidad_id);
        })
        ->paginate($data->query('per_page') ?? 10);
    }


    public function getAccesosByIdUsuario($idUsuario,$data)
    {
        return Acceso::with('usuario.entidad_id')->orderBy('fecha','DESC')->where('usuario_id',$idUsuario)->paginate($data->query('per_page') ?? 10);
    }

    public function createAcceso(array $data = [])
    {
        return Acceso::create($data);
    }
    public function getAccesosIdUsuarioEntidad($idUsuario, $data)
    {
        
        return Acceso::with('usuario.entidad_id','usuario.tipo_usuario')->orderBy('fecha','DESC')->where('usuario_id',$idUsuario)
        ->whereHas('usuario',function($query){
            $query->where('entidad_id',auth()->user()->entidad_id);
        })
        ->paginate($data->query('per_page') ?? 10);
    }
}