<?php
namespace App\Repositories;

use App\Interfaces\AccionInterface;
use App\Models\Accion;
use Carbon\Carbon;

class AccionRepository implements AccionInterface
{
    public function getAll($data)
    {
        return Accion::with('solicitud','usuario_registra')->orderBy('fecha','DESC')->paginate($data->query('per_page') ?? 10);
    }

    public function getById($id)
    {
        return Accion::with('solicitud','usuario_registra')->find($id);
    }

    public function create(array $data )
    {
        
        return Accion::create($data+[
            'usuario_registra'=>auth()->user()->id,
            'fecha'=>Carbon::now()->isoFormat('YYYY-MM-DD HH:mm')
        ]);
    }

    public function update($id,array $data=[])
    {
        $accion = Accion::find($id);
        $accion->update($data);
        return $accion;
    }

    public function delete($id)
    {
        $accion = Accion::find($id);
        $accion->delete();
        return $accion;
    }

    public function getAccionSolicitud($id)
    {
        return Accion::with('solicitud.estado','usuario_registra')->where('solicitud_id',$id)->orderBy('fecha','DESC')->get();
    }
}