<?php
namespace App\Repositories;

use App\Interfaces\ApiCoorporativoInterface;
use App\Mail\EmailCredencialesAPI;
use App\Models\ApiCoorporativo;
use Illuminate\Support\Facades\Mail;

class ApiCoorporativoRepository implements ApiCoorporativoInterface
{
    public function getAll($data)
    {
        $apiCoorporativo = ApiCoorporativo::with('entidad')->where('estado',1)->paginate($data->query('per_page') ?? 10);
       
        return $apiCoorporativo;
    }
    public function create($data)
    {
        
        return ApiCoorporativo::create($data+[
            'estado' => 1,
            'token' => md5($data['entidad_id']),
            'clave_coorporativo' => implode('-', str_split(substr(strtolower(md5(microtime().rand(1000, 9999))), 0, 30), 6)),
        ]);
    }
    public function updateEstadoById($id,array $data=[])
    {
        $apiCoorporativo = ApiCoorporativo::with('entidad')->where('entidad_id',$id)->first();
        if ($apiCoorporativo!=null) {
            if($apiCoorporativo->estado==1){
                $apiCoorporativo->update([
                    'estado' => 0,
                ]);
                return $apiCoorporativo;
            }else{
                $apiCoorporativo->update([
                    'estado' => 1,
                    'token' => md5($apiCoorporativo->entidad_id),
                    'clave_coorporativo' => implode('-', str_split(substr(strtolower(md5(microtime().rand(1000, 9999))), 0, 30), 6)),
                ]);
                return $apiCoorporativo;
            }
        } else {
            return null;
        }
        
    }
    public function updateClaveById($id,array $data=[])
    {
        $apiCoorporativo = ApiCoorporativo::find($id);
        if($apiCoorporativo){
            $apiCoorporativo->update([
                'clave_coorporativo' => implode('-', str_split(substr(strtolower(md5(microtime().rand(1000, 9999))), 0, 30), 6)),
            ]);
            return $apiCoorporativo;
        }
        return null;
    }
    public function getById($id)
    {
        return ApiCoorporativo::with('entidad')->where('estado',1)->where('entidad_id',$id)->first();
    }
    public function getByIdEntidad($id)
    {
        return ApiCoorporativo::with('entidad')->where('estado',1)->where('entidad_id',auth()->user()->entidad_id)->where('entidad_id',$id)->first();
    }

    public function sendEmail($data,array $emails)
    {
        $count=0;
        foreach ($emails as $email) {
            $enviado=Mail::to($email)->send(new EmailCredencialesAPI($data));
            if($enviado){
                $count+=1;
            }
        }
        return $count;
       
    }

}