<?php
namespace App\Repositories;

use App\Interfaces\FirmaInterface;
use App\Interfaces\FirmaRepresentanteLegalInterface;
use App\Models\FirmaEmpresarial;
use App\Models\FirmaRepresentanteLegal;

class FirmaEmpresarialRepository implements FirmaInterface
{
    public function getAll($data){
        return FirmaEmpresarial::with('solicitud')->paginate($data->query('per_page', 10));
    }
    public function getById($firmaId){
        return FirmaEmpresarial::with('solicitud')->find($firmaId);
    }
    public function delete($firmaId){

    }
    public function create(array $firmaDetails){
        return FirmaEmpresarial::create($firmaDetails);
    }
    public function update($firmaId, array $firmaDetails){
        $empresarial=FirmaEmpresarial::with('solicitud')->whereId($firmaId)->first();
        if($empresarial==null){
            return null;
        }else{
            $empresarial->update($firmaDetails);
            $empresarial->solicitud->update($firmaDetails);
            return $empresarial;
        }
    }

    public function getFirmasEntidad($data)
    {
        $empresariales=FirmaEmpresarial::with('solicitud')->
        whereHas('solicitud',function($q){
            $q->where('entidad_solicitante',auth()->user()->entidad_id);
        })->paginate($data->query('per_page') ?? 10);
        return $empresariales;
    }

    public function getFirmasUsuario($data)
    {
        $empresariales=FirmaEmpresarial::with('solicitud')->
        whereHas('solicitud',function($q){
            $q->where('usuario_solicita',auth()->user()->id);
        })->paginate($data->query('per_page') ?? 10);
        return $empresariales;
    }

    public function updateFirmaEntidad($firmaId, array $firmaDetails)
    {
        $empresarial=FirmaEmpresarial::with('solicitud')->
        whereHas('solicitud',function($q){
            $q->where('entidad_solicitante',auth()->user()->entidad_id);
        })->whereId($firmaId)->first();
        if($empresarial==null){
            return null;
        }else{
            $empresarial->update($firmaDetails);
            $empresarial->solicitud->update($firmaDetails);
            return $empresarial;
        }
    }

    public function updateFirmaUsuario($firmaId, array $firmaDetails)
    {
        $empresarial=FirmaEmpresarial::with('solicitud')->
        whereHas('solicitud',function($q){
            $q->where('usuario_solicita',auth()->user()->id);
        })->whereId($firmaId)->first();
        if($empresarial==null){
            return null;
        }else{
            $empresarial->update($firmaDetails);
            $empresarial->solicitud->update($firmaDetails);
            return $empresarial;
        }
    }
}