<?php
namespace App\Repositories;

use App\Interfaces\FirmaInterface;
use App\Interfaces\FirmaRepresentanteLegalInterface;
use App\Models\FirmaJuridica;
use App\Models\FirmaRepresentanteLegal;

class FirmaJuridicaRepository implements FirmaInterface
{
    public function getAll($data){
        return FirmaJuridica::with('solicitud')->paginate($data->query('per_page', 10));
    }
    public function getById($firmaId){
        return FirmaJuridica::with('solicitud')->find($firmaId);
    }
    public function delete($firmaId){

    }
    public function create(array $firmaDetails){
        return FirmaJuridica::create($firmaDetails);
    }
    public function update($firmaId, array $firmaDetails){
        $juridica=FirmaJuridica::with('solicitud')->whereId($firmaId)->first();
        if($juridica==null){
            return null;
        }else{
            $juridica->update($firmaDetails);
            $juridica->solicitud->update($firmaDetails);
            return $juridica;
        }
    }

    public function getFirmasEntidad($data)
    {
        $juridicas=FirmaJuridica::with('solicitud')->
        whereHas('solicitud',function($q){
            $q->where('entidad_solicitante',auth()->user()->entidad_id);
        })->paginate($data->query('per_page') ?? 10);
        return $juridicas;
    }

    public function getFirmasUsuario($data)
    {
        $juridicas=FirmaJuridica::with('solicitud')->
        whereHas('solicitud',function($q){
            $q->where('usuario_solicita',auth()->user()->id);
        })->paginate($data->query('per_page') ?? 10);
        return $juridicas;
    }

    public function updateFirmaEntidad($firmaId, array $firmaDetails)
    {
        $juridica=FirmaJuridica::with('solicitud')->
        whereHas('solicitud',function($q){
            $q->where('entidad_solicitante',auth()->user()->entidad_id);
        })->whereId($firmaId)->first();
        if($juridica==null){
            return null;
        }else{
            $juridica->update($firmaDetails);
            $juridica->solicitud->update($firmaDetails);
            return $juridica;
        }
    }

    public function updateFirmaUsuario($firmaId, array $firmaDetails)
    {
        $juridica=FirmaJuridica::with('solicitud')->
        whereHas('solicitud',function($q){
            $q->where('usuario_solicita',auth()->user()->id);
        })->whereId($firmaId)->first();
        if($juridica==null){
            return null;
        }else{
            $juridica->update($firmaDetails);
            $juridica->solicitud->update($firmaDetails);
            return $juridica;
        }
    }
}