<?php
namespace App\Repositories;

use App\Interfaces\SolicitudFirmaPreviaInterface;
use App\Models\SolicitudPrevia;
use Carbon\Carbon;

class SolicitudFirmaPreviaRepository implements SolicitudFirmaPreviaInterface
{
    public function create(array $data = [])
    {
        return SolicitudPrevia::create($data + [
            'entidad_id' => auth()->user()->entidad_id,
            'usuario_corp' => auth()->user()->id,
            'estado' => true,
        ]);
    }
    public function getSolicitudPorEstado($estado){
        return SolicitudPrevia::where('estado','=',$estado)
                              ->whereNotNull('uanataca_id')
                              ->whereRaw("(tipo_persona !='' or  tipo_persona is not null)")
                              ->get();
    }
}
