<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('entidades_comerciales', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('ruc_empresa')->unique();
            $table->string('nombre_completo');
            $table->string('nombre_comercial');
            $table->string('correo');
            $table->string('direccion');
            $table->string('logo');
            $table->string('correo_coorporativo')->nullable();
            $table->dateTime('fecha_registro');
            $table->text('usuario_registra');
            $table->enum('tipo_entidad',['MAYORISTA','SOCIO']);
            $table->boolean('estado')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('entidades_comerciales');
    }
};
