<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('usuarios', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('nombre');
            $table->string('apellido');
            $table->string('correo')->unique();
            $table->string('correo_recuperacion');
            $table->string('password');
            $table->string('identificacion')->unique();
            $table->enum('tipo_identificacion',['CEDULA','PASAPORTE']);
            $table->enum('genero',['HOMBRE','MUJER']);
            $table->string('usuario_registra');
            $table->foreignUuid('tipo_usuario')
                ->constrained('tipos_usuarios')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->boolean('estado')->default(1);
            $table->foreignUuid('cod_pais')
                ->constrained('cod_paises')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->string('foto_perfil_url')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('usuarios');
    }
};
