<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('solicitudes_firmas', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('numerodocumento');
            $table->string('nombres');
            $table->string('apellido1');
            $table->string('apellido2');
            $table->enum('tipodocumento',['CEDULA','PASAPORTE']);
            $table->enum('tipo_solicitud',['PERSONA NATURAL','MIEMBRO DE EMPRESA','REPRESENTANTE LEGAL','PERSONA JURIDICA']);
            $table->string('coddactilar');
            $table->string('ruc_personal')->nullable();
            $table->enum('sexo',['HOMBRE','MUJER']);
            $table->enum('contenedor',['1','2','3']);
            $table->date('fecha_nacimiento');
            $table->string('nacionalidad');
            $table->string('telfCelular');
            $table->string('telFijo')->nullable();
            $table->string('eMail');
            $table->string('telfCelular2')->nullable();
            $table->string('provincia');
            $table->string('ciudad');
            $table->string('direccion');
            $table->enum('vigenciafirma',['7 dias','1 año','2 años', '3 años','4 años', '5 años']);
            $table->string('f_cedulaFront');
            $table->foreignUuid('entidad_solicitante')
                ->constrained('entidades_comerciales')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->foreignUuid('usuario_solicita')
                ->constrained('usuarios')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->string('f_cedulaBack')->nullable();
            $table->string('f_selfie')->nullable();
            $table->string('f_copiaruc')->nullable();
            $table->string('f_adicional1')->nullable();
            $table->string('f_adicional2')->nullable();
            $table->string('f_adicional3')->nullable();
            $table->string('f_adicional4')->nullable();
            $table->boolean('firma_generada')->default(0);
            $table->dateTime('fecha_solicitud');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('solicitudes_firmas');
    }
};
