<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('contactos', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('entidad_id')->nullable()
                ->constrained('entidades_comerciales')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->string('celular');
            $table->string('fijo')->nullable(); 
            $table->string('whatsapp')->nullable();
            $table->foreignUuid('usuario_id')->nullable()
                ->constrained('usuarios')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contactos');
    }
};
