<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('api_coorporativos', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('entidad_id')
            ->constrained('entidades_comerciales')
            ->cascadeOnUpdate()
            ->restrictOnDelete();
            $table->boolean('estado')->default(0);
            $table->string('token');
            $table->string('clave_coorporativo');
            $table->string('url_acceso')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('api_coorporativos');
    }
};
