<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('diagnostico_dispositivo', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('dispositivo_id')
                ->constrained('dispositivo')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->string('observaciones_diagnostico');
            $table->integer('estado_diagnostico');
            $table->string('verision_apk_instalada');
            $table->string('ip_publica');
            $table->integer('estado_camara');
            $table->integer('nivel_bateria');
            $table->integer('estado_impresora');
            $table->string('velocidad_subida');
            $table->string('velocidad_bajada');
            $table->string('tipo_conexion');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('diagnostico_dispositivo');
    }
};
