<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('estados_solicitudes', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('solicitud_id')
            ->constrained('solicitudes_firmas')
            ->cascadeOnUpdate()
            ->restrictOnDelete();
            $table->enum('tipo_solicitud',['PERSONA NATURAL','MIEMBRO DE EMPRESA','REPRESENTANTE LEGAL','PERSONA JURIDICA']);
            $table->enum('estado',['BORRADOR','NUEVO','PROCESANDO','APROBADO','FIRMA GENERADA','FIRMA VENCIDA','CANCELADO','OBSERVACIONES','DATOS INCOMPLETOS']);
            $table->string('observacion')->nullable();
            $table->string('fecha_vencimiento')->nullable();
            $table->string('uid_proveedor');
            $table->string('creado_por');
            $table->string('fecha_registro');
            $table->string('pago_id')->nullable();
            $table->string('fecha_pago')->nullable();
            $table->string('precio')->nullable();
            $table->string('num_factura')->nullable();
            $table->boolean('pagado')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('estados_solicitudes');
    }
};
