<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tipos_firmas', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->enum('tipo_firma',['ARCHIVO','TOKEN']);
            $table->string('descripcion');
            $table->enum('tiempo_validez',['7 dias','1 año','2 años', '3 años','4 años', '5 años']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tipos_firmas');
    }
};
