<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('precios_firmas', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('entidad_id')
                ->constrained('entidades_comerciales')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->double('precio');
            $table->double('pvp');
            $table->foreignUuid('tipo_firma_id')
                ->constrained('tipos_firmas')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->dateTime('fecha_inicio');
            $table->dateTime('fecha_fin');
            $table->boolean('estado')->default(1);
            $table->foreignUuid('usuario_registra')
                ->constrained('usuarios')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->double('disc_renovacion');
            $table->double('disc_serv_publicos');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('precios_firmas');
    }
};
