<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('interfaz_entidad_comercial', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('entidad_id')
            ->constrained('entidades_comerciales')
            ->cascadeOnUpdate()
            ->restrictOnDelete();
            $table->string('url_logo');
            $table->string('color_principal');
            $table->string('color_secundario');
            $table->string('color_gradient');
            $table->string('slug');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('interfaz_entidad_comercial');
    }
};
