<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('registro_lotes', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('usuario_registra')
            ->constrained('usuarios')
            ->cascadeOnUpdate()
            ->restrictOnDelete();
            $table->foreignUuid('entidad_id')
                ->constrained('entidades_comerciales')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->string('fecha_carga');
            $table->string('archivo_url')->nullable();
            $table->string('finalizado')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('registro_lotes');
    }
};
