<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('solicitudes_previas', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('solicitud_id')->nullable()
                ->constrained('solicitudes_firmas')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->string('email');
            $table->string('identificacion');
            $table->string('telefono');
            $table->foreignUuid('usuario_corp')->nullable()
                ->constrained('usuarios')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->foreignUuid('entidad_id')->nullable()
                ->constrained('entidades_comerciales')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->boolean('estado');
            $table->enum('contenedor', ['1', '2', '3']);
            $table->boolean('requiere_facturacion');
            $table->integer('numero_facturas');
            $table->boolean('requiere_firma');
            $table->text('uanataca_id')->nullable();
            $table->enum('vigenciafirma', ['7 dias', '1 año', '2 años', '3 años', '4 años', '5 años']);
            $table->double('precio');
            $table->string('tipo_persona');
            $table->string('tipo_solicitud');
            $table->string('datos_persona')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('solicitudes_previas');
    }
};
