<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('facturacion', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('numero_factura')->nullable();
            $table->string('cliente');
            $table->string('identificacion');
            $table->string('total');
            $table->foreignUuid('pago_id')->nullable()
                ->constrained('pagos')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->text('detalle');
            $table->string('estado');
            $table->string('clave_acceso');
            $table->string('mensaje');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('facturacion');
    }
};
