<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pagos_pinpad', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->foreignUuid('entidad_id')
                ->constrained('entidades_comerciales')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->double('valor_pagado');
            $table->dateTime('fecha_pago');
            $table->string('usuario_registra');
            $table->string('tipo_pago');
            $table->string('comprobante_url');
            $table->string('descripcion');
            $table->boolean('validado');
            $table->string('usuario_valida');
            $table->foreignUuid('solicitud_previa_id')
                ->constrained('solicitudes_previas')
                ->cascadeOnUpdate()
                ->restrictOnDelete();
            $table->string('CodigoRespuesta');
            $table->string('RedAdquirente');
            $table->string('CodigoRespuestaAut');
            $table->string('Lote');
            $table->string('Hora');
            $table->string('Fecha');
            $table->string('Autorizacion');
            $table->string('TID');
            $table->string('MID');
            $table->string('NombreAdquirente');
            $table->string('TarjetaHabiente');
            $table->string('Referencia');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pagos_pinpad');
    }
};
