<?php

use App\Http\Controllers\AccesoController;
use App\Http\Controllers\AccionController;
use App\Http\Controllers\ApiCoorporativoController;
use App\Http\Controllers\CargaMasivaController;
use App\Http\Controllers\CargaMasivaPreviaController;
use App\Http\Controllers\CodigoPaisesController;
use App\Http\Controllers\EntidadComercialController;
use App\Http\Controllers\EstadoSolicitudController;
use App\Http\Controllers\FirmaEmpresarialController;
use App\Http\Controllers\FirmaJuridicaController;
use App\Http\Controllers\FirmaRepresentanteLegalController;
use App\Http\Controllers\InterfazEntidadComercialController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\PrecioFirmaController;
use App\Http\Controllers\RegistroLoteController;
use App\Http\Controllers\SolicitudFirmaController;
use App\Http\Controllers\SolicitudFirmaPublicaController;
use App\Http\Controllers\SolicitudLoteController;
use App\Http\Controllers\SolicitudPreviaController;
use App\Http\Controllers\SolicitudPreviaAuthController;
use App\Http\Controllers\TipoFirmaController;
use App\Http\Controllers\TipoFirmaPublicController;
use App\Http\Controllers\TipoUsuarioController;
use App\Http\Controllers\UsuarioController;
// use App\Http\Controllers\RedActivaController;
use App\Http\Controllers\AppVersionController;
use App\Http\Controllers\DispositivoController;
use App\Http\Controllers\DispositivoNoAuthController;
use App\Http\Controllers\DiagnosticoDispositivoController;
use App\Http\Controllers\DiagnosticoDispositivoAuthController;
use App\Http\Controllers\FacturacionController;
use App\Http\Controllers\LogDispositivoAuthController;
use App\Http\Controllers\LogDispositivoController;
use App\Http\Controllers\PagoPinpadController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProxyController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


// //LOGIN Y REGISTRO
Route::controller(LoginController::class)->group(function () {
    Route::post('auth/login', 'login');
    Route::post('auth/password/cambiar-password', 'cambiarClave');
    Route::post('auth/password/recuperar-password', 'sendResetLinkEmail');
});

//ENTIDAD COMERCIAL
Route::controller(EntidadComercialController::class)->group(function () {
    Route::post('entidad-comercial/crear', 'crearEntidadComercial');
    Route::get('entidad-comercial/listar', 'listarEntidadesComerciales');
    Route::put('entidad-comercial/actualizar/{id}', 'actualizarEntidadComercial');
    Route::put('entidad-comercial/eliminar/{id}', 'eliminarEntidadComercial');
    Route::get('entidad-comercial/ver/{entidad}', 'verEntidadComercial');
    Route::get('entidad-comercial/{id}/listar-usuarios', 'listarUsuariosEntidadComercial');
    Route::put('entidad-comercial/mi-entidad/actualizar', 'actualizarMiEntidadComercial');
    Route::get('entidad-comercial/mi-entidad/ver', 'verMiEntidadComercial');
    Route::get('entidad-comercial/ruc/buscar', 'buscarEntidadRuc');
});

//USUARIO
Route::controller(UsuarioController::class)->group(function () {
    Route::post('usuario/crear', 'crearUsuario');
    Route::get('usuario/listar', 'listarUsuarios');
    Route::put('usuario/actualizar/{id}', 'actualizarUsuario');
    Route::delete('usuario/eliminar/{id}', 'eliminarUsuario');
    Route::get('usuario/ver/{usuario}', 'verUsuario');
    Route::put('usuario/password/cambiar', 'cambiarPassword');
    Route::post('usuario/entidad/crear', 'crearUsuarioEntidad');
    Route::put('usuario/entidad/actualizar/{id}', 'actualizarUsuarioEntidad');
    Route::put('usuario/perfil/actualizar', 'actualizarPerfil');
    Route::get('usuario/buscar', 'buscarUsuarioCedula');
    Route::get('usuario/entidad/buscar', 'buscarUsuarioCedulaEntidad');
});

//PRECIO_FIRMAS
Route::controller(PrecioFirmaController::class)->group(function () {
    Route::post('precio-firma/crear', 'crearPrecioFirma');
    Route::post('precio-firma/listar', 'listarPreciosFirmas');
    Route::put('precio-firma/actualizar/{id}', 'actualizarPrecioFirma');
    Route::delete('precio-firma/eliminar/{id}', 'eliminarPrecioFirma');
    Route::get('precio-firma/ver/{id}', 'verPrecioFirma');
    Route::get('precio-firma/entidad-comercial/{id}/listar', 'listarPreciosFirmasEntidad');
    Route::put('precio-firma/pvp/actualizar/{id}', 'actualizarPVP');
});

//INTERFAZ ENTIDAD COMERCIAL
Route::controller(InterfazEntidadComercialController::class)->group(function () {
    Route::post('iec/crear', 'crearIEC');
    Route::get('iec/listar', 'listarIEC');
    Route::put('iec/actualizar/{id}', 'actualizarIEC');
    // Route::delete('precio-firma/eliminar/{id}','eliminarPrecioFirma');
    Route::get('iec/ver/{id}', 'verIEC');
    Route::get('iec/slug/buscar', 'buscarSlug');
    Route::get('iec/cargar', 'cargarIEC');
});

//COD PAISES
Route::controller(CodigoPaisesController::class)->group(function () {
    Route::get('codigos/listar', 'listarCodigoPaises');
});

//TIPOS DE FIRMAS
Route::controller(TipoFirmaController::class)->group(function () {
    Route::get('tipos-firmas/listar', 'listarTiposFirmas');
});

//TIPOS DE FIRMAS PUBLICAS
Route::controller(TipoFirmaPublicController::class)->group(function () {
    Route::post('tiposfirmas/listar', 'listarTiposFirmas');
});

//TIPOS DE FIRMAS PUBLICAS para consulta de precio por datos
Route::controller(TipoFirmaPublicController::class)->group(function () {
    Route::post('tiposfirmas/consultarPrecio', 'consultarPrecio');
});

//TIPOS DE USAURIOS
Route::controller(TipoUsuarioController::class)->group(function () {
    Route::get('tipos-usuarios/listar', 'listarTiposUsuarios');
});

//ACCESOS
Route::controller(AccesoController::class)->group(function () {
    Route::get('acceso/listar', 'listarAccesos');
    Route::get('acceso/ver/{id}', 'listarAccesosUsuario');
    Route::get('acceso/usuario-entidad/ver/{id}', 'listarAccesosUsuarioEntidad');
    Route::get('acceso/entidad/listar', 'listarAccesosEntidad');
});

//SOLICITUD FIRMA
Route::controller(SolicitudFirmaController::class)->group(function () {
    Route::post('solicitud-firma/crear', 'crearSolicitudFirma');
    Route::get('solicitud-firma/listar', 'listarSolicitudesFirma');
    Route::get('solicitud-firma/reporte/excel', 'export');
    Route::get('solicitud-firma/ver/{id}', 'verSolicitudFirma');
    Route::put('solicitud-firma/actualizar/{id}', 'actualizarSolicitudFirma');
    Route::get('solicitud-firma/nueva/listar', 'listarSolicitudesFirmaNuevas');
    Route::get('solicitud-firma/administrador/vence-quince/listar', 'listarSolicitudesQuince');
    Route::get('solicitud-firma/administrador/vence-siete/listar', 'listarSolicitudesSiete');
    Route::get('solicitud-firma/socio/vence-quince/listar', 'listarSolicitudesCaducanQuinceEntidad');
    Route::get('solicitud-firma/socio/vence-siete/listar', 'listarSolicitudesCaducanSieteEntidad');
    Route::get('solicitud-firma/usuario/vence-quince/listar', 'listarSolicitudesCaducanQuinceUsuario');
    Route::get('solicitud-firma/usuario/vence-siete/listar', 'listarSolicitudesCaducanSieteUsuario');
    Route::get('solicitud-firma/socio/nueva/listar', 'listarSolicitudesFirmaNuevasEntidad');
    Route::get('solicitud-firma/buscar', 'buscarSolicitudesFirmaIdentificacion');
    Route::get('solicitud-firma/entidad/buscar', 'buscarSolicitudesFirmaIdentificacionEntidad');
    Route::get('solicitud-firma/usuario/buscar', 'buscarSolicitudesFirmaIdentificacionUsuarioSolicita');
    Route::get('solicitud-firma/entidad/listar', 'listarSolicitudesEntidad');
    Route::get('solicitud-firma/usuario/listar', 'listarSolicitudesUsuarioSolicita');
    Route::put('solicitud-firma/entidad/actualizar/{id}', 'actualizarSolicitudEntidad');
    Route::put('solicitud-firma/usuario/actualizar/{id}', 'actualizarSolicitudUsuarioSolicita');
});

//FIRMA REPRESENTANTE LEGAL
Route::controller(FirmaRepresentanteLegalController::class)->group(function () {
    Route::post('firma-representante-legal/crear', 'crearFirmaRepresentanteLegal');
    Route::get('firma-representante-legal/listar', 'listarFirmasRepresentanteLegal');
    Route::get('firma-representante-legal/ver/{id}', 'verFirmaRepresentanteLegal');
    Route::put('firma-representante-legal/actualizar/{id}', 'actualizarFirmaRepresentanteLegal');
    Route::get('firma-representante-legal/entidad/listar', 'listarFirmasRepresentanteEntidad');
    Route::get('firma-representante-legal/usuario/listar', 'listarFirmasRepresentanteUsuario');
    Route::put('firma-representante-legal/entidad/actualizar/{id}', 'actualizarFirmaRepresentanteEntidad');
    Route::put('firma-representante-legal/usuario/actualizar/{id}', 'actualizarFirmaRepresentanteUsuario');
});

//FIRMA JURIDICA
Route::controller(FirmaJuridicaController::class)->group(function () {
    Route::post('firma-juridica/crear', 'crearFirmaJuridica');
    Route::get('firma-juridica/listar', 'listarFirmasJuridicas');
    Route::get('firma-juridica/ver/{id}', 'verFirmaJuridica');
    Route::put('firma-juridica/actualizar/{id}', 'actualizarFirmaJuridica');
    Route::get('firma-juridica/entidad/listar', 'listarFirmasJuridicasEntidad');
    Route::get('firma-juridica/usuario/listar', 'listarFirmasJuridicasUsuario');
    Route::put('firma-juridica/entidad/actualizar/{id}', 'actualizarFirmaJuridicaEntidad');
    Route::put('firma-juridica/usuario/actualizar/{id}', 'actualizarFirmaJuridicaUsuario');
});

//FIRMA EMPRESARIAL
Route::controller(FirmaEmpresarialController::class)->group(function () {
    Route::post('firma-empresarial/crear', 'crearFirmaEmpresarial');
    Route::get('firma-empresarial/listar', 'listarFirmasEmpresariales');
    Route::get('firma-empresarial/ver/{id}', 'verFirmaEmpresarial');
    Route::put('firma-empresarial/actualizar/{id}', 'actualizarFirmaEmpresarial');
    Route::get('firma-empresarial/entidad/listar', 'listarFirmasEmpresarialesEntidad');
    Route::get('firma-empresarial/usuario/listar', 'listarFirmasEmpresarialesUsuario');
    Route::put('firma-empresarial/entidad/actualizar/{id}', 'actualizarFirmaEmpresarialEntidad');
    Route::put('firma-empresarial/usuario/actualizar/{id}', 'actualizarFirmaEmpresarialUsuario');
});

//ACCION
Route::controller(AccionController::class)->group(function () {
    Route::post('accion/crear', 'crearAccion');
    Route::get('accion/listar', 'listarAcciones');
    Route::get('accion/ver/{id}', 'verAccion');
    Route::put('accion/actualizar/{id}', 'actualizarAccion');
    Route::delete('accion/eliminar/{id}', 'eliminarAccion');
    Route::get('accion/solicitud/listar/{id}', 'listarAccionesSolicitud');
});

//API COORPORATIVO
Route::controller(ApiCoorporativoController::class)->group(function () {
    Route::post('api-coorporativo/crear', 'crearApiCoorporativo');
    Route::get('api-coorporativo/listar', 'listarApiCoorporativo');
    Route::get('api-coorporativo/ver/{id}', 'verApiCoorporativo');
    Route::put('api-coorporativo/actualizar-estado/{id}', 'actualizarApiCoorporativo');
    Route::put('api-coorporativo/actualizar-clave/{id}', 'actualizarClaveApiCoorporativo');
    Route::get('api-coorporativo/entidad/ver/{id}', 'verApiCoorporativoEntidad');
    Route::post('api-coorporativo/enviar-credenciales', 'enviarCredenciales');
});

//ESTADO SOLICITUD
Route::controller(EstadoSolicitudController::class)->group(function () {
    Route::put('estado-solicitud/actualizar/{id}', 'actualizarEstadoSolicitud');
    Route::put('estado-solicitud/entidad/actualizar/{id}', 'actualizarEstadoSolicitudEntidad');
});

//CARGA MASIVA
Route::controller(CargaMasivaController::class)->group(function () {
    Route::post('carga-masiva/cargar', 'cargar');
});

//CARGA MASIVA SOLICITUDES PREVIAS
Route::controller(CargaMasivaPreviaController::class)->group(function () {
    Route::post('carga-masiva-previas/cargar', 'cargar');
    Route::post('qr/previas/cargar', 'crear');
});

//REGISTRO LOTES
Route::controller(RegistroLoteController::class)->group(function () {
    Route::get('registro-lote/listar', 'listar');
    Route::get('registro-lote/entidad/listar', 'listarEntidad');
    Route::get('registro-lote/usuario/listar', 'listarUsuario');
});

//SOLICITUDES LOTES
Route::controller(SolicitudLoteController::class)->group(function () {
    Route::get('solicitud-lote/listar/{id}', 'listar');
    Route::get('solicitud-lote/entidad/listar/{id}', 'listarEntidad');
    Route::get('solicitud-lote/usuario/listar/{id}', 'listarUsuario');
});

// Route::get('/test', [UsuarioController::class, 'test']);
//SOLICITUD FIRMA PUBLICA
Route::controller(SolicitudFirmaPublicaController::class)->group(function () {
    Route::get('solicitud-firma-publica/ver/{id}', 'verSolicitudFirma');
});

//ENTIDAD COMERCIAL
// Route::controller(RedActivaController::class)->group(function () {
//     // Route::post('nueva-solicitud/crear','crearNuevaSolicitud');
// });

//NUEVA SOLICITUD REDACTIVA
Route::controller(SolicitudPreviaController::class)->group(function () {
    Route::post('solicitud/crear', 'crearNuevaSolicitud');
    Route::post('solicitud-api/crear', 'crearNuevaSolicitud');
    Route::post('solicitudes/listar', 'listarSolicitudes');
    Route::post('solicitud-inicial/ver/{id}', 'buscarSolicitud');
    Route::put('solicitud/previa/actualizar/{id}', 'actualizarSolicitud');
    // Solicitud normal crear sin auth
    Route::post('solicitud-firma/crear/noAuth', 'crearSolicitudFirma');
    Route::post('tiposfirmasprecio/listar', 'listarPreciosFirmasEntidad');
});
//Route::post('solicitud-api/crear', [SolicitudPreviaController::class, 'nuevaSolicitudTerceros']);

//NUEVA SOLICITUD REDACTIVA AUTH
Route::controller(SolicitudPreviaAuthController::class)->group(function () {
    Route::post('solicitud-previa/crear', 'crearNuevaSolicitudAuth');
    Route::get('solicitud/previa/resendmail/{id}', 'sendEmail');
    Route::post('solicitudes/previas/listar', 'listarSolicitudesEntidad');
    Route::post('solicitudes/previas/entidad', 'listarSolicitudesPrevias');
    Route::post('solicitudes/previas/kiosko', 'listarSolicitudesKioscos');
    Route::post('solicitudes/previas/reporte', 'reporteSolicitudesPrevias');
});

//APP VERSION PARA KIOSKOS
Route::controller(AppVersionController::class)->group(function () {
    Route::post('app-version/crear', 'crearAppVersion');
    Route::post('app-version/listar', 'listarVersionesApp');
    Route::post('app-version/activar/{id}', 'activarAppVersion');
    Route::post('app-version/activa', 'versionAppActiva');
    Route::post('app-version/correo/enviar', 'enviarCorreo');
});

//DISPOSITIVOS PARA KIOSKOS
Route::controller(DispositivoController::class)->group(function () {
    Route::post('dispositivo/crear', 'crearDispositivo');
    Route::post('dispositivo/actualizar/{id}', 'actualizarDispositivo');
    Route::post('dispositivo/listar', 'listarDispositivo');
    Route::post('dispositivo/entidad/ver/{id}', 'consultarDispositivoPorEntidad');
});
Route::controller(DispositivoNoAuthController::class)->group(function () {
    Route::post('dispositivo/api/actualizar/{id}', 'actualizarDispositivoApi');
    Route::post('dispositivo/ver', 'consultarDispositivo');
    Route::post('dispositivo/ultimaConexion', 'ultimaConexion');
    Route::post('dispositivo/ping', 'hacerPing');
});

//DIAGNOSTICO DISPOSITIVOS PARA KIOSKOS
Route::controller(DiagnosticoDispositivoController::class)->group(function () {
    Route::post('diagnostico/dispositivo/crear', 'crearDiagnosticoDispositivo');
});
Route::controller(DiagnosticoDispositivoAuthController::class)->group(function () {
    Route::post('diagnostico/dispositivos/listar', 'listarDiagnosticoDispositivos');
    Route::post('diagnosticos/dispositivo/listar/{id}', 'listarDiagnosticosDispositivo');
    Route::post('diagnostico/dispositivo/ultimo/{id}', 'ultimoDiagnosticoDispositivo');
});

//DIAGNOSTICO DISPOSITIVOS PARA KIOSKOS
Route::controller(LogDispositivoController::class)->group(function () {
    Route::post('log/dispositivo/crear', 'crearlogDispositivo');
});
Route::controller(LogDispositivoAuthController::class)->group(function () {
    Route::post('log/dispositivos/listar', 'listarLogDispositivos');
    Route::post('logs/dispositivo/listar/{id}', 'listarLogsDispositivo');
    Route::post('logs/dispositivo/dia/{id}', 'listarLogsDiaDispositivo');
});

//FACTURACION 
Route::controller(FacturacionController::class)->group(function () {
    Route::post('factura/crear', 'crearFactura');
});

//PAGOS 
Route::controller(PagoPinpadController::class)->group(function () {
    Route::post('pago/crear', 'crearPagoPinpad');
});


//CRON DE CAMBIO DE ESTADO DE SOLICITUD
Route::controller(\App\Http\Controllers\CronCambiosEstadoSolicitudController::class)->group(function () {
    Route::get('cambio-estado-solicitud/cambio/{estado}', 'cambioEstado');
});

Route::any('/proxy/firmas/{url}', [ProxyController::class, 'proxyToFirmas'])->where('url', '.*');